/***********************************************************************/
/*  This file is part of the ARM Toolchain package                     */
/*  Copyright KEIL ELEKTRONIK GmbH 2011                                */
/***********************************************************************/
/*                                                                     */
/*  FlashDev.c:  Device Description for ES32W3120 Flash             */
/*                                                                     */
/***********************************************************************/

#include "FlashOS.H"        /* FlashOS Structures, do not modify! */
#include "FlashParams.h"    /* flash parameters specification */

#ifdef FLASH_MEM
struct FlashDevice const FlashDevice  =  {
    FLASH_DRV_VERS,                         /* Driver Version, do not modify! */
    "ES32F369X W25Q128JV",                  /* Device Name */
    EXTSPI,                                 /* Device Type: DATA BUS */
    FLASH_BASE_ADDR,                        /* Device Start Address, adjecnt with MCU SRAM address */
    FLASH_SIZE,                             /* Device Size in Bytes (16M) */
    FLASH_PAGE_SIZE,                        /* Programming Page Size, in byte */
    0,                                      /* Reserved, must be 0 */
    0xFF,                                   /* Initial Content of Erased Memory */
    4000,                                   /* Program Page Timeout 4,000 mSec */
    20000,                                  /* Erase Sector Timeout 20,000 mSec */
    {
        FLASH_SECTORE_SIZE, 0x00000000,     /* Sector size and start offset of this sector group */
        SECTOR_END
    }
};
#endif

